#ifndef _VarArgs_VarArgs_h
#define _VarArgs_VarArgs_h

#include <Core/Core.h>

NAMESPACE_UPP;

class VarArgs : Moveable<VarArgs> {
    Vector<Any> args;
public:
    template<class T> VarArgs&  Add(const T& t)                 { args.Add().Create<T>() = t; return *this; }
    template<class T> VarArgs&  operator<<(const T& t)          { return Add(t); }
    template<class T> T&        Set(int i, const T& t)          { T& arg = args[i]; arg = t; return arg; }  
    template<class T> T&        Insert(int i, const T& t)       { return args.Insert(i, t); }
    template<class T> T&        Get(int i)                      { ASSERT(Is<T>(i)); return args[i].Get<T>(); }
    inline void                 Remove(int i)                   { args.Remove(i); }
    inline int                  GetCount() const                { return args.GetCount(); }
    inline void                 Clear()                         { args.Clear(); }
    template<class T> bool      Is(int i) const                 { args[i].Is<T>(); }
    inline bool                 IsEmpty() const                 { return args.IsEmpty(); }
    inline bool                 IsPicked() const                { return args.IsPicked(); }     
    
    VarArgs()                   {}

};
END_UPP_NAMESPACE;
#endif
